/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.util.SwingUtils;

public class PasswordDialog
extends JDialog {
    private JLabel passwordLbl;
    private JPasswordField password;
    private JButton login;

    public PasswordDialog(LaunchFrame instance, boolean modal) {
        super((Frame)instance, modal);
        this.setupGui();
        this.getRootPane().setDefaultButton(this.login);
        this.login.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!new String(PasswordDialog.this.password.getPassword()).isEmpty()) {
                    LaunchFrame.tempPass = new String(PasswordDialog.this.password.getPassword());
                    PasswordDialog.this.setVisible(false);
                }
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("PASSWORD_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.passwordLbl = new JLabel(I18N.getLocaleString("PASSWORD_PASSLABEL"));
        this.password = new JPasswordField(16);
        this.login = new JButton(I18N.getLocaleString("MAIN_SUBMIT"));
        panel.add(this.passwordLbl);
        panel.add(this.password);
        panel.add(this.login);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.passwordLbl, hSpring, "West", (Component)panel);
        hSpring = SwingUtils.springSum(hSpring, Spring.width(this.passwordLbl), Spring.constant(10));
        layout.putConstraint("West", (Component)this.password, hSpring, "West", (Component)panel);
        hSpring = SwingUtils.springSum(hSpring, Spring.width(this.password), Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.login, 0, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.passwordLbl, 0, "Baseline", (Component)this.password);
        layout.putConstraint("North", (Component)this.password, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.passwordLbl), Spring.height(this.password));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.login, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.login), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

